/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Either;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;
import ram.talia.hexal.api.casting.iota.GateIota;

public class HexalObfMapState
extends class_18 {
    private BiMap<UUID, Integer> gateMap = HashBiMap.create();
    private BiMap<UUID, GateData> typedGateMap = HashBiMap.create();
    private BiMap<UUID, MoteData> moteMap = HashBiMap.create();

    @Nullable
    public Integer getGateInt(UUID uuid) {
        return (Integer)this.gateMap.get((Object)uuid);
    }

    @Nullable
    public GateData getGateData(UUID uuid) {
        return (GateData)this.typedGateMap.get((Object)uuid);
    }

    @Nullable
    public UUID getGateUUID(int gateInt) {
        return (UUID)this.gateMap.inverse().get((Object)gateInt);
    }

    public UUID getOrCreateGateUUID(GateData gData) {
        UUID uuid = this.getGateUUID(gData.index());
        if (uuid == null) {
            uuid = this.newGate(gData);
        }
        return uuid;
    }

    private void addGateToMap(UUID uuid, GateData gData) {
        this.gateMap.put((Object)uuid, (Object)gData.index());
        this.typedGateMap.put((Object)uuid, (Object)gData);
        this.method_80();
    }

    public UUID newGate(GateData gData) {
        UUID uuid = UUID.randomUUID();
        while (this.gateMap.containsKey((Object)uuid) || this.typedGateMap.containsKey((Object)uuid)) {
            uuid = UUID.randomUUID();
        }
        this.addGateToMap(uuid, gData);
        return uuid;
    }

    @Nullable
    public MoteData getMoteData(UUID uuid) {
        return (MoteData)this.moteMap.get((Object)uuid);
    }

    @Nullable
    public UUID getMoteObfUUID(MoteData moteData) {
        return (UUID)this.moteMap.inverse().get((Object)moteData);
    }

    public UUID getOrCreateMoteObfUUID(MoteData moteData) {
        UUID uuid = this.getMoteObfUUID(moteData);
        if (uuid == null) {
            uuid = this.newMote(moteData);
        }
        return uuid;
    }

    private void addMoteToMap(UUID uuid, MoteData moteData) {
        this.moteMap.put((Object)uuid, (Object)moteData);
        this.method_80();
    }

    public UUID newMote(MoteData moteData) {
        UUID uuid = UUID.randomUUID();
        while (this.moteMap.containsKey((Object)uuid)) {
            uuid = UUID.randomUUID();
        }
        this.addMoteToMap(uuid, moteData);
        return uuid;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2487 gateMapNbt = new class_2487();
        for (UUID uuid : this.typedGateMap.keySet()) {
            class_2487 gateDataNbt = ((GateData)this.typedGateMap.get((Object)uuid)).toNbt();
            gateMapNbt.method_10566(uuid.toString(), (class_2520)gateDataNbt);
        }
        nbt.method_10566("hexalTypedGateMap", (class_2520)gateMapNbt);
        class_2487 moteMapNbt = new class_2487();
        for (UUID uuid : this.moteMap.keySet()) {
            MoteData moteData = (MoteData)this.moteMap.get((Object)uuid);
            class_2487 moteDataNbt = new class_2487();
            moteDataNbt.method_25927("storageUuid", moteData.uuid);
            moteDataNbt.method_10569("index", moteData.index);
            moteDataNbt.method_10582("itemID", moteData.itemID);
            moteMapNbt.method_10566(uuid.toString(), (class_2520)moteDataNbt);
        }
        nbt.method_10566("hexalMoteMap", (class_2520)moteMapNbt);
        return nbt;
    }

    public static HexalObfMapState createFromNbt(class_2487 tag) {
        HexalObfMapState serverState = new HexalObfMapState();
        class_2487 typedGateMapNbt = tag.method_10562("hexalTypedGateMap");
        if (typedGateMapNbt == null || typedGateMapNbt.method_33133()) {
            class_2487 gateMapNbt = tag.method_10562("hexalGateMap");
            for (String uuidString : gateMapNbt.method_10541()) {
                GateData simpleData = new GateData(gateMapNbt.method_10550(uuidString), 0, null, null);
                serverState.addGateToMap(UUID.fromString(uuidString), simpleData);
            }
        } else {
            for (String uuidString : typedGateMapNbt.method_10541()) {
                GateData gData = GateData.fromNbt(typedGateMapNbt.method_10562(uuidString));
                serverState.addGateToMap(UUID.fromString(uuidString), gData);
            }
        }
        class_2487 moteMapNbt = tag.method_10562("hexalMoteMap");
        for (String uuidString : moteMapNbt.method_10541()) {
            class_2487 moteDataNbt = moteMapNbt.method_10562(uuidString);
            MoteData moteData = new MoteData(moteDataNbt.method_25926("storageUuid"), moteDataNbt.method_10550("index"), moteDataNbt.method_10558("itemID"));
            serverState.addMoteToMap(UUID.fromString(uuidString), moteData);
        }
        return serverState;
    }

    public static HexalObfMapState getServerState(MinecraftServer server) {
        class_26 persistentStateManager = server.method_3847(class_1937.field_25179).method_17983();
        HexalObfMapState serverState = (HexalObfMapState)persistentStateManager.method_17924(HexalObfMapState::createFromNbt, HexalObfMapState::new, "ducky-periphs:hexal_gate_map");
        serverState.method_80();
        return serverState;
    }

    public static GateData GateDataFromIota(GateIota iota) {
        Either target = iota.getTarget();
        if (iota.isDrifting() || target == null) {
            return new GateData(iota.getGateIndex(), 0, null, null);
        }
        if (target.left().isPresent()) {
            return new GateData(iota.getGateIndex(), 1, (class_243)target.left().get(), null);
        }
        if (target.right().isPresent()) {
            GateIota.EntityAnchor anchor = (GateIota.EntityAnchor)target.right().get();
            return new GateData(iota.getGateIndex(), 2, anchor.offset(), anchor.uuid());
        }
        return new GateData(iota.getGateIndex(), 0, null, null);
    }

    public record GateData(int index, int type, class_243 tVec, UUID entUuid) {
        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("index", this.index);
            nbt.method_10569("type", this.type);
            if (this.type == 1 || this.type == 2) {
                nbt.method_10549("tVecX", this.tVec.field_1352);
                nbt.method_10549("tVecY", this.tVec.field_1351);
                nbt.method_10549("tVecZ", this.tVec.field_1350);
            }
            if (this.type == 2) {
                nbt.method_25927("entUuid", this.entUuid);
            }
            return nbt;
        }

        public static GateData fromNbt(class_2487 nbt) {
            int index = nbt.method_10550("index");
            int type = nbt.method_10550("type");
            class_243 tVec = null;
            UUID entUuid = null;
            if (type == 1 || type == 2) {
                tVec = new class_243(nbt.method_10574("tVecX"), nbt.method_10574("tVecY"), nbt.method_10574("tVecZ"));
            }
            if (type == 2) {
                entUuid = nbt.method_25926("entUuid");
            }
            return new GateData(index, type, tVec, entUuid);
        }
    }

    public record MoteData(UUID uuid, int index, String itemID) {
    }
}

